# 画面設計書 17-OPFS SAHPool Digest

## 概要

本ドキュメントは、SQLite WASMプロジェクトにおけるOPFS SAHPool Digest画面の設計仕様を定義するものである。

### 本画面の処理概要

本画面は、OPFS SAHPool VFSのダイジェスト（ハッシュ）計算に関するバグ修正テストを実行するためのページである。

**業務上の目的・背景**：SQLite v3.49.0以前とそれ以降のバージョン間で、OPFS SAHPoolのダイジェスト計算方式に変更があった。本画面は、異なるバージョン間でのDBファイル互換性を検証するためのテストを提供する。具体的には、旧バージョンで作成したDBを新バージョンで読み取り、さらに旧バージョンに戻しても読み取れることを確認する。ただし、新バージョンで作成したDBは旧バージョンでは読み取れず、破損（corrupt）として扱われる点を検証する。

**画面へのアクセス方法**：直接 `tests/opfs/sahpool/digest.html` にアクセスする。通常のインデックスページからのリンクは設定されていない場合がある（特殊なバグ修正テストのため）。

**主要な操作・処理内容**：
1. ページ読み込み時にWorker（digest-worker.js）を起動
2. Worker内でOPFS SAHPool VFSを使用してDBを作成/読み取り
3. ダイジェスト計算の互換性をテスト
4. 結果を画面に表示

**画面遷移**：
- 遷移元: 手動アクセス（特殊テスト用）
- 関連画面: OPFS SAHPool テスト

**権限による表示制御**：特になし（開発者向けテストページ）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | SQLiteライブラリ初期化 | 主機能 | SAHPoolダイジェストテスト用初期化 |
| 43 | OS抽象化層（VFS） | 主機能 | SAHPool VFSのダイジェスト検証 |

## 画面種別

テスト実行・結果表示画面

## URL/ルーティング

```
/ext/wasm/tests/opfs/sahpool/digest.html
```

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| cb-log-reverse | 入力 | checkbox | 任意 | ログ順序逆転 |
| テスト結果 | 出力 | text/HTML | - | テストログと結果 |

## 表示項目

| 項目名 | 説明 | 表示条件 |
|--------|------|----------|
| タイトル（h1） | "sqlite3 tester: OpfsSAHPool Digest" | 常時表示 |
| 説明文 | ダイジェスト計算テストの説明とバージョン間互換性の注意事項 | 常時表示 |
| ログ逆順チェックボックス | "Reverse log order?" | 常時表示 |
| テスト出力エリア | テストログ | テスト実行中・完了後 |

## イベント仕様

### 1-ページ読み込み

1. インラインスクリプトでログ出力関数を設定
2. Worker（digest-worker.js）を起動
3. Worker初期化完了を待機

### 2-Workerメッセージ受信

- `type: 'log'`: 通常ログを画面に表示
- `type: 'error'`: エラーログを表示、endOfWork(false)で失敗表示
- `type: 'initialized'`: Worker初期化完了

### 3-テスト完了

endOfWork(passed)呼び出し時:
- passed=true: h1とtitleに"PASS:"プレフィックス、tests-passクラス
- passed=false: h1とtitleに"FAIL:"プレフィックス、tests-failクラス

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ダイジェストテスト | テスト用テーブル | CREATE/INSERT/SELECT | バージョン間互換性検証 |

### テーブル別更新項目詳細

Worker内で作成されるテーブル。詳細はdigest-worker.jsの実装に依存。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG001 | 情報 | "Running opfs-sahpool digest tests..." | テスト開始時 |
| MSG002 | 情報 | "worker says: {message}" | Workerからのログ |
| MSG003 | 情報 | "{workerId}: Worker initialized" | Worker初期化完了時 |
| MSG004 | 成功 | "End of work chain. If you made it this far, you win." | テスト成功時 |
| MSG005 | エラー | "worker says: {message}" | Workerエラー発生時 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| Worker内エラー | 'error'メッセージで通知、endOfWork(false)でFAIL表示 |
| ダイジェスト不一致 | Worker内でエラー検出、失敗報告 |

## 備考

- このテストは自動化が困難で、手動での実行が必要
- テスト手順:
  1. v3.49.0以前のバージョンでDBを作成
  2. 新バージョン（本修正含む）で同じDBにアクセス → 成功すべき
  3. 再びv3.49.0以前に戻してアクセス → 成功すべき
  4. 新バージョンで新規作成したDBをv3.49.0以前でアクセス → 失敗（corrupt扱い）
- 2025-02-03に追加されたバグ修正テスト

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Worker通信メッセージとログ出力構造。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | digest.html | `ext/wasm/tests/opfs/sahpool/digest.html` | インラインスクリプト内のメッセージ処理 |

**読解のコツ**: mapToString関数でエラーオブジェクトを文字列化。logClass関数でCSSクラス付きログ出力。

#### Step 2: エントリーポイントを理解する

HTMLファイルのインラインスクリプト。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | digest.html | `ext/wasm/tests/opfs/sahpool/digest.html` | Worker生成とonmessageハンドラ |

**主要処理フロー**:
- **行52-96**: ログ出力関数の設定
- **行98-114**: log, warn, error, toss関数定義
- **行116-129**: endOfWork関数（PASS/FAIL表示）
- **行131-147**: Worker生成とonmessageハンドラ

#### Step 3: バグ修正の背景を理解する

コメントに記載されたバグ修正の詳細。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | digest.html | `ext/wasm/tests/opfs/sahpool/digest.html` | 行26-51のコメント |

**主要処理フロー**:
- **行26-35**: 2025-02-03付けのバグ修正コメント
- **行36-51**: バージョン間互換性の詳細説明

### プログラム呼び出し階層図

```
digest.html
    │
    └─ インラインスクリプト
           │
           ├─ ログ関数設定
           │      ├─ mapToString()
           │      ├─ logClass()
           │      ├─ log(), warn(), error(), toss()
           │      └─ endOfWork()
           │
           └─ new Worker('digest-worker.js')
                  │
                  └─ onmessage
                         ├─ 'log' → log('worker says:', ...)
                         ├─ 'error' → error(...) + endOfWork(false)
                         └─ 'initialized' → log(workerId, 'initialized', ...)
```

### データフロー図

```
[Worker]                              [メインスレッド]

digest-worker.js                      digest.html
     │                                     │
     ├─ OPFS SAHPool初期化                 │
     │                                     │
     ├─ postMessage({type:'initialized'}) ─▶ log()
     │                                     │
     ├─ ダイジェストテスト実行              │
     │                                     │
     ├─ postMessage({type:'log'}) ────────▶ log('worker says:')
     │                                     │
     └─ (成功/失敗)                        │
           │                               │
           ├─ 'log' ──────────────────────▶ endOfWork(true)
           └─ 'error' ────────────────────▶ endOfWork(false)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| digest.html | `ext/wasm/tests/opfs/sahpool/digest.html` | テンプレート | メイン画面HTML（インラインスクリプト含む） |
| digest-worker.js | `ext/wasm/tests/opfs/sahpool/digest-worker.js` | ソース | ダイジェストテストWorker |
| emscripten.css | `ext/wasm/common/emscripten.css` | スタイル | 共通スタイルシート |
| testing.css | `ext/wasm/common/testing.css` | スタイル | テストページ用スタイル |
